import logging
from datetime import date

import yt.wrapper as yt
from flask import current_app as app
from flask_script import Command
from nile.api.v1 import aggregators as na

from jafar import advisor_replica_mongo
from jafar.utils.io import get_cluster

logger = logging.getLogger(__name__)


class UpdatePhoneStats(Command):
    def run(self):
        yt.update_config(app.config['YT_CONFIG'])
        path = yt.TablePath(app.config['YT_PHONE_ACTIVATED'], append=True)
        activated_count = advisor_replica_mongo.db.phone.find({'activated': True}).count()
        recs = [{'fielddate': date.today().isoformat(), 'activated_count': activated_count}]
        yt.write_table(path, recs, raw=False)
        job = get_cluster().job()
        job.table(
            app.config['YT_PHONE_ACTIVATED']
        ).groupby(
            'fielddate'
        ).aggregate(
            activated_count=na.max('activated_count')
        ).put(
            app.config['YT_PHONE_ACTIVATED']
        )
        job.run()
