import logging

from flask import current_app as app
from flask_script import Command, Option

from jafar.datasets import get_dataset_processor

logger = logging.getLogger(__name__)


def update_datasets(countries, dataset_sources):
    for source in dataset_sources:
        get_dataset_processor(source).update_many(countries)


class UpdateDatasets(Command):
    """
    Grabs data from YT tables (or other source),
    splits it across countries/categories and
    stores on disk as pandas dataframes.
    """

    option_list = (
        Option(
            '--country', dest='country',
            required=True, type=str, action='store', help='Comma separated list of countries to use'
        ),
        Option(
            '--dataset-sources', dest='dataset_sources', required=False,
            default='', type=str, action='store', help='Comma separated list of sources to use'
        )
    )

    def run(self, country, dataset_sources):
        dataset_sources = dataset_sources.split(',') if dataset_sources else app.config['DEFAULT_DATASETS']
        countries = country.split(',')

        update_datasets(countries, dataset_sources)
