import datetime
import logging

from flask import current_app as app

from jafar.utils.cache import ObjectCache

logger = logging.getLogger(__name__)


class BlacklistCache(ObjectCache):
    expiration_interval = datetime.timedelta(minutes=7)

    def __init__(self, component):
        super(BlacklistCache, self).__init__()
        self.component = component

    def load(self):
        from jafar.mongo_configs.blacklist import Blacklist

        return list(Blacklist.objects(component=self.component))

    def get_blacklists(self, country, clids):
        for blacklist in self.get():
            if blacklist.targeting.apply(country, clids):
                yield blacklist


blacklist_caches = {
    'recommendations': BlacklistCache('recommendations'),
    'arranger': BlacklistCache('arranger')
}
