from jafar.datasets.advisor_mongo_dataset import AdvisorMongoDatasetProcessor
from jafar.datasets.arranger_dataset import ArrangerLaunchesDatasetProcessor
from jafar.datasets.conversions_dataset import (
    ConversionsNoPromoDatasetProcessor,
    ConversionsPromoDatasetProcessor
)
from jafar.datasets.general_metrika_dataset import GeneralMetrikaDatasetProcessor
from jafar.datasets.locality_dataset import LocalityDatasetProcessor
from jafar.datasets.vanga_dataset import VangaDatasetProcessor


def get_dataset_processor(dataset_source):
    processors = [AdvisorMongoDatasetProcessor, GeneralMetrikaDatasetProcessor, ConversionsNoPromoDatasetProcessor,
                  ConversionsPromoDatasetProcessor, VangaDatasetProcessor,
                  LocalityDatasetProcessor, ArrangerLaunchesDatasetProcessor]
    return {p.source: p for p in processors}[dataset_source]()
