from jafar.estimators.base import BaseEstimator
from jafar.utils import check_frame

import numpy as np
import pandas as pd


class Random(BaseEstimator):
    """
    Simple `most popular` recommender.
    """
    basket_required = False

    def fit(self, X, y=None):
        return self

    def predict(self, X, basket=None):
        check_frame(X, ('user', 'item'))

        return pd.DataFrame(dict(
            user=X['user'],
            item=X['item'],
            value=np.random.rand(len(X['user']))
        ))

    def predict_top_n(self, X, n, basket=None):
        assert isinstance(n, int), 'n must be integer'
        check_frame(X, ('user',))

        return pd.DataFrame(dict(
            user=np.repeat(X['user'].values, n),
            item=np.random.randint(0, self.n_items, len(X['user']) * n),
            value=np.random.rand(len(X['user']) * n)
        ))
