from marshmallow import fields
from werkzeug.datastructures import MultiDict


class CommaSeparatedList(fields.List):
    def _serialize(self, value, attr, obj, **kwargs):
        return u','.join(map(str, super(CommaSeparatedList, self)._serialize(value, attr, obj, **kwargs)))

    def _deserialize(self, value, attr, data, **kwargs):
        return super(CommaSeparatedList, self)._deserialize(
                list(filter(bool, value.split(','))),
                attr, data, **kwargs
            )


class ListField(fields.List):
    def _deserialize(self, value, attr, data):
        # because of flask MultiDict
        if isinstance(data, MultiDict):
            value = data.getlist(attr)
        return super(ListField, self)._deserialize(value, attr, data)
