from flask import Blueprint

from jafar.arranger.view import ArrangerView
from jafar.feed.views import RecommendationFeedView, RecConfigView, SearchView
from jafar.vanga.view import VangaView

feed_blueprint = Blueprint('feed', __name__)

feed_blueprint.add_url_rule(
    '/feed/<experiment_name>',
    view_func=RecommendationFeedView.as_view('recommendation_feed'),
    methods=['POST']
)

feed_blueprint.add_url_rule(
    '/search/<experiment_name>',
    view_func=SearchView.as_view('search'),
    methods=['GET']
)

feed_blueprint.add_url_rule(
    '/rec_configs',
    view_func=RecConfigView.as_view('recommendation_configs'),
    methods=['GET']
)

feed_blueprint.add_url_rule(
    '/vanga/<experiment_name>',
    view_func=VangaView.as_view('vanga'),
    methods=['GET', 'POST']
)

feed_blueprint.add_url_rule(
    '/arranger/<experiment_name>',
    view_func=ArrangerView.as_view('arranger'),
    methods=['POST']
)
