

class SimpleItemFilter(object):

    def __init__(self, items=None, hash_set=None):
        if items is None:
            items = []
        if hash_set:
            self.content = hash_set
        else:
            self.content = set()
            self.content.update(items)

    def add(self, item):
        self.content.add(item)

    def update(self, items):
        self.content.update(items)

    def __contains__(self, item):
        return item in self.content


class CombinedItemFilter(object):
    """
    Allows filtering against multiple hashset-like
    objects. This filter is useful when different sets
    can't be combined together (NOTE: is it relevant anymore
    after redis is gone?)
    """

    def __init__(self, filters):
        self.content = filters

    def add_filter(self, item_filter):
        self.content.append(item_filter)

    def __contains__(self, item):
        return any(item in item_filter for item_filter in self.content)
