# -*- coding: utf-8 -*-
import re
import string

from mongoengine import ValidationError

from jafar import db


class Adnetwork(db.Document):
    name = db.StringField(required=True, unique=True, verbose_name='Name')

    def __unicode__(self):
        return self.name

    meta = {
        'allow_inheritance': True,
        'indexes': ['name'],
        'index_background': True,
        'auto_create_index': False,
    }


DIRECT_ADNETWORK_NAME_REGEXP = re.compile(r'direct(-[a-z0-9]+){1,2}')


class DirectAdnetwork(Adnetwork):
    api_key = db.StringField(required=True, verbose_name='API key')

    def clean(self):
        self.name = self.name.strip()
        self.api_key = self.api_key.strip()

        if len(self.api_key) != 64 or not all(symbol in string.hexdigits for symbol in self.api_key):
            raise ValidationError('Api key should be 64 symbols long hex string')

        if not DIRECT_ADNETWORK_NAME_REGEXP.match(self.name):
            raise ValidationError(u'Имя должно иметь вид direct-<advertiser>-<affiliate> или direct-<advertiser>, где '
                                  u'<advertiser> и <affiliate> состоят из маленьких латинских букв и цифр')

