from wtforms import validators

from jafar import db


class MongoConfig(db.Document):
    name = db.StringField(verbose_name='Name', required=True, unique=True, validators=[validators.InputRequired()])
    description = db.StringField(verbose_name='Description', required=False)

    meta = {
        'abstract': True,
        'strict': False,
        'auto_create_index': False,
    }

    def clean(self):
        super(MongoConfig, self).clean()
        self.name = self.name.strip()

    def __unicode__(self):
        return '<{} : {}>'.format(self.__class__.__name__, self.name)

    def get_params(self):
        params = self.to_mongo().to_dict()
        for extra_field in ('name', 'description', '_cls', '_id'):
            if extra_field in params:
                del params[extra_field]
        return params
