# coding=utf-8
import re

from jafar.mongo_configs.base import db, MongoConfig

LAUNCHER_TITLES = [
    u'launcher',
    u'лончер',
    u'лаунчер',
]


class Distributor(db.Document):
    name = db.StringField(required=True)
    clid1006 = db.StringField(required=True)

    def __unicode__(self):
        return self.name


class Targeting(db.EmbeddedDocument):
    distributors = db.ListField(db.ReferenceField(Distributor), required=False)
    countries = db.ListField(db.StringField(), required=False)

    def dictributors_condition(self, clids):
        if not self.distributors:
            return True
        user_clid1006 = clids.get('clid1006')
        for distributor in self.distributors:
            if distributor.clid1006 == user_clid1006:
                return True
        return False

    def country_condition(self, country):
        if not self.countries:
            return True
        return country in self.countries

    def apply(self, country, clids):
        return self.dictributors_condition(clids) and self.country_condition(country)

    def __unicode__(self):
        result = []
        if self.distributors:
            result.append('distributors: ' + ', '.join(map(unicode, self.distributors)))
        if self.countries:
            result.append('countries: ' + ', '.join(self.countries))
        return '; '.join(result)


class Blacklist(MongoConfig):
    component = db.StringField(required=True)
    package_names = db.ListField(db.StringField(), required=False)
    package_names_regex = db.ListField(db.StringField(), required=False)
    white_list = db.ListField(db.StringField(), required=False)
    publishers = db.ListField(db.StringField(), required=False)
    categories = db.ListField(db.StringField(), required=False)
    is_launcher = db.BooleanField(required=False)
    targeting = db.EmbeddedDocumentField(Targeting)

    def get_filtering_rules(self):
        if self.publishers:
            yield 'publisher', lambda publisher: publisher in self.publishers
        if self.package_names:
            yield 'item', lambda package_name: package_name in self.package_names
        if self.package_names_regex:
            yield 'item', self.match_package_names_regex
        if self.is_launcher:
            yield 'item', lambda package_name: 'launcher' in package_name.lower()
            yield 'title', lambda title: any(
                launcher_title in title.lower() for launcher_title in LAUNCHER_TITLES)
        if self.categories:
            yield 'category', lambda category: category in self.categories

    def match_package_names_regex(self, package_name):
        for package_name_regex in self.package_names_regex:
            if re.match(package_name_regex, package_name):
                return True
        return False

    def get_excluded_items(self):
        return self.white_list
