from mongoengine.fields import IntField

from jafar.models import cards
from jafar.mongo_configs.base import MongoConfig


class CardMongoConfig(MongoConfig):
    card_config_class = None
    min_count = IntField(required=True, min_value=1, default=1)
    max_count = IntField(required=True, min_value=1, default=10)

    meta = {
        'allow_inheritance': True,
        'strict': False
    }


class RandomSingleAppCard(CardMongoConfig):
    card_config_class = cards.RandomSingleAppCardConfig


class SingleAppCard(CardMongoConfig):
    card_config_class = cards.SingleAppCardConfig

    count = IntField(required=True, min_value=1, default=1)


class MultiappsRichCard(CardMongoConfig):
    card_config_class = cards.MultiappsRichCardConfig


class MultiappsCard(CardMongoConfig):
    card_config_class = cards.MultiappsCardConfig


class MultiappsCardMultirows(CardMongoConfig):
    card_config_class = cards.MultiappsMultirowsCardConfig


# Rotatable cards used in launcher categories and widget
class MultiappsWidgetCard(CardMongoConfig):
    card_config_class = cards.MultiappsWidgetCardConfig
    rotation_interval = IntField(required=False, min_value=0, default=0)


class ExpandableButtonCard(CardMongoConfig):
    card_config_class = cards.ExpandableButtonCardConfig
    rotation_interval = IntField(required=False, min_value=0, default=0)


class ScrollableCard(CardMongoConfig):
    card_config_class = cards.ScrollableCardConfig
    rotation_interval = IntField(required=False, min_value=0, default=0)


class ScrollableExpandableCard(CardMongoConfig):
    card_config_class = cards.ScrollableExpandableCardConfig
    rotation_interval = IntField(required=False, min_value=0, default=0)


class ZenSingleappCardCard(CardMongoConfig):
    card_config_class = cards.ZenSingleappCardConfig


class SetupWizardCard(CardMongoConfig):
    card_config_class = cards.SetupWizardCardConfig


class CustomUICard(CardMongoConfig):
    card_config_class = cards.CustomUICardConfig


class GiftsCard(CardMongoConfig):
    card_config_class = cards.GiftsCardConfig
