from jafar import db
from jafar.mongo_configs.base import MongoConfig


class CustomConversionConfig(MongoConfig):
    offer_ids = db.ListField(db.StringField(), verbose_name='Offer id')

    def clean(self):
        super(CustomConversionConfig, self).clean()
        self.offer_ids = [item.strip() for item in self.offer_ids]
        self.offer_ids = filter(bool, self.offer_ids)
