from jafar import db


class GlobalJafarConfig(db.Document):
    placement_mapping = db.DictField(verbose_name='Yandex Direct placement mapping', required=False, default=dict)

    meta = {
        'max_documents': 1
    }


def get_global_config():
    global_config = GlobalJafarConfig.objects.first()
    assert global_config is not None, 'Please create the global config'
    return global_config
