from datetime import datetime, timedelta

from jafar import db
from jafar.mongo_configs import MongoConfig


class VangaExperimentConfig(MongoConfig):
    lifetime_seconds = db.IntField(min_value=0, required=True, verbose_name='Client stats TTL in sec')
    exceptional_lifetime = db.IntField(min_value=0, required=True, default=36000,
                                       verbose_name='Client TTL in case of emtpy response')
    stats_groups = db.ListField(db.StringField(choices=('personal_no_fallback', 'personal_fallback', 'total')),
                                verbose_name='Features to response from server',
                                default=['personal_fallback'])
    meta = {
        'db_alias': 'advisor',
        'strict': False
    }


class VangaModel(db.Document):  # storage for all models from Nirvana for tracking
    comment = db.StringField()
    metrics = db.DictField()
    features = db.DictField()
    workflow = db.StringField()
    content = db.BinaryField()
    created_at = db.DateTimeField(default=datetime.utcnow)
    expire_at = db.DateTimeField(default=lambda: datetime.utcnow() + timedelta(30))

    meta = {'collection': 'vanga_models', 'strict': False}


class ClassifierModel(db.Document):  # production storage for clients to download
    vanga_model_name = db.StringField(primary_key=True)
    filename = db.StringField()

    meta = {'strict': False, 'db_alias': 'advisor'}
