# ids for the data frames shared between pipeline blocks

# main input data frames
# these frames come from designated datasets and contain
# basic user-item related data (installs, user/item features, user-item events etc.)

FRAME_KEY_ITEM_FEATURES = 'item_features'
FRAME_KEY_USER_FEATURES = 'user_features'

# different sources of installs
FRAME_KEY_ADVISOR_MONGO_INSTALLS = 'advisor_mongo_installs'
FRAME_KEY_ADVISOR_METRIKA_INSTALLS = 'advisor_metrika_installs'
FRAME_KEY_GENERAL_METRIKA_INSTALLS = 'general_metrika_installs'
FRAME_KEY_CONVERSIONS_NO_PROMO = 'conversions_no_promo'
FRAME_KEY_CONVERSIONS_PROMO = 'conversions_promo'
# app_launch events for smart launch functionality
FRAME_KEY_LAUNCHES = 'launches'
FRAME_KEY_ARRANGER_ITEM_FEATURES = 'arranger_item_features'

# locality data frames
FRAME_KEY_LOCALITY = 'locality'

# frame keys and corresponding dataset names
data_frame_keys = {
    FRAME_KEY_LOCALITY: 'locality',
    FRAME_KEY_ADVISOR_MONGO_INSTALLS: 'advisor_mongo',
    FRAME_KEY_USER_FEATURES: 'advisor_mongo',
    FRAME_KEY_ITEM_FEATURES: 'advisor_mongo',
    FRAME_KEY_ADVISOR_METRIKA_INSTALLS: 'advisor_metrika',
    FRAME_KEY_GENERAL_METRIKA_INSTALLS: 'general_metrika',
    FRAME_KEY_CONVERSIONS_NO_PROMO: 'conversions_no_promo',
    FRAME_KEY_CONVERSIONS_PROMO: 'conversions_promo',
    FRAME_KEY_LAUNCHES: 'arranger',
    FRAME_KEY_ARRANGER_ITEM_FEATURES: 'arranger'
}
item_feature_keys = (FRAME_KEY_ARRANGER_ITEM_FEATURES, FRAME_KEY_ITEM_FEATURES)
user_feature_keys = (FRAME_KEY_USER_FEATURES,)

# other kinds of input data
FRAME_KEY_REMOVED_ITEMS = 'removed_apps'
FRAME_KEY_DISLIKED_ITEMS = 'disliked_apps'
FRAME_KEY_CLIDS = 'clids'
FRAME_KEY_PROMO = 'promo'
FRAME_KEY_USAGE_STATS = 'usage_stats'
FRAME_KEY_USAGE_STATS_YESTERDAY = 'usage_stats_yesterday'
FRAME_KEY_HYBRID_MODEL_ITEM_FEATURES = 'hybrid_model_item_features'
FRAME_KEY_HYBRID_MODEL_USER_FEATURES = 'hybrid_model_user_features'
FRAME_KEY_PROMO_VIEWS_COUNTS = 'promo_views_counts'

# main frame that contains user/item combinations (can be built from "data frames")
FRAME_KEY_TARGET = 'target'

# result frame (pipeline response), contains the same users as target frame,
# either the same (ranked) or different (predicted) items, and also recommender score column
FRAME_KEY_PREDICTIONS = 'predictions'

# contains user's already owned items (ones recommender is *allowed* to know about in case of cross-validation)
FRAME_KEY_BASKET = 'basket'

# frame with cross validation results
FRAME_KEY_CV_RESULTS = 'cross_validation'

STORAGE_KEY_FOR_ITEM_CATEGORY_MAPPING = 'item_category_mapping'

FRAME_KEY_RANGE = 'range'

FRAME_DEFAULT_ITEMS = 'default_apps'

all_frame_keys = (
    FRAME_KEY_TARGET,
    FRAME_KEY_BASKET,
    FRAME_KEY_ITEM_FEATURES,
    FRAME_KEY_USER_FEATURES,
    FRAME_KEY_ADVISOR_MONGO_INSTALLS,
    FRAME_KEY_ADVISOR_METRIKA_INSTALLS,
    FRAME_KEY_GENERAL_METRIKA_INSTALLS,
    FRAME_KEY_CONVERSIONS_NO_PROMO,
    FRAME_KEY_CONVERSIONS_PROMO,
    FRAME_KEY_LAUNCHES,
    FRAME_KEY_PREDICTIONS,
    FRAME_KEY_LOCALITY,
)
