import numpy as np
import re


class RegexpFeature(object):
    def __init__(self, regexp):
        self.regexp = regexp


def extract_feature_names(frame, features):
    """
    Returns a list of columns which can be matched
    against a list of features (which can include regexps).
    """
    extracted_features = []
    for feature in features:
        for name in frame.columns:
            if isinstance(feature, RegexpFeature):
                if re.match(feature.regexp, name) is not None:
                    extracted_features.append(name)
            else:
                if feature == name:
                    extracted_features.append(name)
                    break
    return sorted(extracted_features)


def get_predictions_frame(target, items):
    """
    Combine predictions frame for further ranking from input target frame and available items
    """

    columns = list({'user', 'placement'} & set(target.columns))
    assert 'user' in columns, 'User is required column for target frame'
    target = np.unique(target[columns])
    predictions = items.tile(len(target))
    target = target.repeat(len(items))
    for column in columns:
        predictions = predictions.append_column(target[column], column)
    return predictions
