from jafar.pipelines.predefined.arranger import (
    create_vanish_pipeline,
    create_domestos_pipeline, create_toilet_duck_pipeline, create_mr_muscle_pipeline, create_general_pipeline,
    create_constant_pipeline)
from jafar.pipelines.predefined.gifts import (
    create_santa_pipeline,
    create_rudolph_pipeline,
)
from jafar.pipelines.predefined.kano import (
    create_smoke_pipeline,
    create_kano_pipeline,
    create_local_pipeline,
    create_sonya_pipeline
)

predefined_pipelines = {
    'sonya_neighbors': create_sonya_pipeline,
    'local': create_local_pipeline,
    'smoke': create_smoke_pipeline,
    'kano': create_kano_pipeline,
    'sonya': create_sonya_pipeline,
}

predefined_promo_pipelines = {
}

predefined_gifts_pipelines = {
    'santa': create_santa_pipeline,
    'rudolph': create_rudolph_pipeline,
}

predefined_arranger_pipelines = {
    'vanish': create_vanish_pipeline,
    'domestos': create_domestos_pipeline,
    'duck': create_toilet_duck_pipeline,
    'mr_muscle': create_mr_muscle_pipeline,
    'general': create_general_pipeline,
    'constant': create_constant_pipeline,
}

all_predefined_pipelines = {}
all_predefined_pipelines.update(predefined_pipelines)
all_predefined_pipelines.update(predefined_gifts_pipelines)
all_predefined_pipelines.update(predefined_arranger_pipelines)
