from jafar.pipelines.blocks import data
from jafar.pipelines.blocks import features
from jafar.pipelines.blocks import blend
from jafar.pipelines.blocks import estimator
from jafar.pipelines import ids
from jafar import estimators

# some shortcuts


def get_data_block_from_config(pipeline_config, data_frames,
                               item_features=None, user_features=None):
    """
    In offline mode, returns an instance of OfflineReadDataBlock
    which reads the chosen data frames, and in online mode
    return OnlineReadDataBlock, which is constrained to advisor
    mongo data.
    """
    if pipeline_config.online:
        return data.OnlineReadDataBlock()
    else:
        return data.OfflineReadDataBlock(
            output_data=data_frames,
            item_features=item_features,
            user_features=user_features
        )


def get_blending_itemitem_block(
        data_frame, fit_estimator,
        predictions_frame=ids.FRAME_KEY_PREDICTIONS, feature_name='ii',
        n_folds=10, estimator_class=estimators.ItemItem):
    return blend.BlendingFeatureBlock(
        fit_blocks=[
            ('fit_itemitem_blend',
             estimator.EstimatorBlock(input_frame=data_frame, estimator_class=estimator_class))
        ],
        predict_blocks=[
            ('feature_itemitem_blend', features.EstimatorFeatureBlock(
                input_frame=predictions_frame, estimator_class=estimator_class, feature_name=feature_name
            ))
        ],
        features_names=[feature_name], fit_frame=data_frame, predict_frame=predictions_frame,
        n_folds=n_folds, fit_with_full_data=fit_estimator,
    )
