from scipy.sparse import csr_matrix
import numpy as np


def cosine(arr):
    """
    Uses sparse matrices, pretty fast even for large
    datasets.
    """
    return_sparse = False if isinstance(arr, np.ndarray) else True

    arr = csr_matrix(arr)

    similarity = arr.dot(arr.T).astype('float32')
    square_mag = similarity.diagonal()
    inv_square_mag = 1. / square_mag
    inv_square_mag[np.isinf(inv_square_mag)] = 0
    inv_square_mag = csr_matrix(inv_square_mag)
    inv_mag = inv_square_mag.sqrt()
    cosine = similarity.multiply(inv_mag)
    cosine = cosine.T.multiply(inv_mag)

    if not return_sparse:
        cosine = cosine.toarray()
    return cosine


def asymmetric_cosine(arr, alpha):
    """
    TODO: rewrite the same way as `cosine`
    for sparse matrix support
    """
    inter_product = arr.dot(arr.T)
    square_lengths = arr.multiply(arr).sum(axis=1)
    square_lengths = square_lengths.reshape(square_lengths.shape[0], 1)
    denominator = np.power(square_lengths, alpha).dot(np.power(square_lengths, 1 - alpha).T)
    result = inter_product / denominator
    result[denominator == 0.0] = 0.0
    return np.array(result)
