function processOfferIdAjaxWidget($el, name) {
    if (name != 'select2-ajax-offer-id') {
        return false;
    }
    var opts = {
        width: 'resolve',
        minimumInputLength: 0,
        placeholder: 'data-placeholder',
        allowClear: true,
        ajax: {
            url: $el.attr('data-url'),
            data: function (term, page) {
                var package_name_field = $el.attr('package-name-field');
                return {
                    package_name: document.getElementById(package_name_field).value,
                    query: term,
                    offset: (page - 1) * 10,
                    limit: 10
                };
            },
            results: function (data, page) {
                var results = [];
                for (var k in data) {
                    var v = data[k];

                    results.push({id: v[0], text: v[1]});
                }
                return {
                    results: results,
                    more: results.length == 10
                };
            }
        },
        initSelection: function (element, callback) {
            $el = $(element);
            var value = jQuery.parseJSON($el.attr('data-json'));
            var result = null;
            if (value) {result = {id: value[0], text: value[1]};}
            callback(result);
        }
    };
    $el.select2(opts);
    return true;
}

faForm.addFieldConverter(processOfferIdAjaxWidget);

