import logging
from copy import copy

import numpy as np

logger = logging.getLogger(__name__)


delimiter = '.'


def make_key(*args):
    return delimiter.join(map(str, args)).lower()


class Storage(object):
    allow_parallel_access = False

    def __deepcopy__(self, memo):
        logger.warning('Deep copy for storage not supported.')
        return copy(self)

    def store(self, key, value):
        raise NotImplementedError

    def get_proxy(self, key):
        raise NotImplementedError

    def make_mapping(self, key, values):
        values = np.unique(values)
        reverse_mapping = dict(enumerate(values))
        mapping = {v: k for k, v in enumerate(values)}
        self.store(key, mapping)
        self.store(key=self.get_reverse_mapping_key(key), value=reverse_mapping)

    @staticmethod
    def get_reverse_mapping_key(key):
        return key + '_reversed'

    def _map(self, dict_, keys, default):
        return [dict_.get(key, default) for key in keys]

    def map_values(self, mapping_key, values, default, reverse=False):
        if reverse:
            mapping_key = self.get_reverse_mapping_key(mapping_key)
        dict_ = self.get_proxy(mapping_key)
        return self._map(dict_, values, default)

    def to_dict(self):
        raise NotImplementedError

    @classmethod
    def from_dict(self, dictionary):
        raise NotImplementedError
