"""
To be able to keep one instance of storage
per app, we utilize flask extension's design:
http://flask.pocoo.org/docs/0.12/extensiondev/
"""

from flask import current_app


class StorageWrapper(object):

    def __init__(self, app=None):
        if app is not None:
            self.init_app(app)

    def init_app(self, app):
        with app.app_context():
            app.extensions['jafar_storage'] = self.connect()

    def connect(self):
        raise NotImplementedError

    @property
    def storage(self):
        if 'jafar_storage' not in current_app.extensions:
            raise Exception("Not initialized. Forgot to call `init_app`, maybe?")
        return current_app.extensions['jafar_storage']
