from jafar.storages.base import Storage
from jafar.storages.exceptions import StorageKeyError
from jafar.storages.flask_jafar_storage import StorageWrapper

import logging

logger = logging.getLogger(__name__)


class MemoryStorage(Storage):

    def __init__(self):
        self._storage = {}

    def has_key(self, key):
        return key in self._storage

    def store(self, key, value):
        self._storage[key] = value

    def remove(self, key):
        try:
            del self._storage[key]
        except KeyError:
            pass

    def get_proxy(self, key):
        try:
            return self._storage[key]
        except KeyError:
            raise StorageKeyError(key)

    def get_object(self, key):
        try:
            return self._storage[key]
        except KeyError:
            raise StorageKeyError(key)

    def get_dict_values(self, key, dict_keys):
        _dict = self._storage.get(key)
        if _dict:
            return [_dict.get(k) for k in dict_keys]

    def get_matrix_rows(self, key, idx):
        return self.get_object(key)[idx]

    def iteritems(self):
        return self._storage.iteritems()

    def to_dict(self):
        return self._storage

    @classmethod
    def from_dict(cls, dictionary):
        instance = cls()
        instance._storage = dictionary
        return instance


class MemoryStorageWrapper(StorageWrapper):

    def connect(self):
        return MemoryStorage()
