from jafar.storages.memory import MemoryStorage

import shelve
import pickle


class ShelvedStorage(MemoryStorage):

    def __init__(self, path):
        self.path = path
        self.open()

    def open(self):
        self._storage = shelve.open(self.path, protocol=pickle.HIGHEST_PROTOCOL)

    def close(self):
        self._storage.close()
