import numpy as np

from jafar.feed.schema import ArrangerUserInfo
from jafar.mongo_configs import arranger
from jafar.tests.fixtures.profile import user_id, apps

user = ArrangerUserInfo(device_id=user_id, packages=apps, grid_height=5, grid_width=4, defaults=[])
config = {
    'screens_template': [{
        'items': [
            {
                'item_type': arranger.PLACEHOLDER_TYPE,
                'cell': {'x': 0, 'y': -2},
                'span': {'x': 6, 'y': 3},
                'rearrange': True,
            },
            {
                'item_type': arranger.WIDGET_ITEM_TYPE,
                'value': 'com.yandex.launcher/.pogoda',
                'cell': {'x': 1, 'y': 0},
                'span': {'x': 6, 'y': 2},
                'rearrange': False,
            },
            {
                'item_type': arranger.APP_ITEM_TYPE,
                'value': 'ru.mamba.client',
                'cell': {'x': 0, 'y': -2},
                'span': {'x': 1, 'y': 1},
                'rearrange': False,
            },
            {  # widget won't be set because this widget has already been set
                'item_type': arranger.WIDGET_ITEM_TYPE,
                'value': 'com.yandex.launcher/.pogoda',
                'cell': {'x': 0, 'y': -3},
                'span': {'x': 1, 'y': 1},
                'rearrange': False,
            },
            {  # app won't be set because it is not installed
                'item_type': arranger.APP_ITEM_TYPE,
                'value': 'ru.totally_not_installed.app',
                'cell': {'x': 1, 'y': -3},
                'span': {'x': 1, 'y': 1},
                'rearrange': False,
            },
            {  # app won't be set because its cell is too big
                'item_type': arranger.APP_ITEM_TYPE,
                'value': 'com.pinterest',
                'cell': {'x': 6, 'y': -3},
                'span': {'x': 1, 'y': 1},
                'rearrange': False,
            }
        ]
    }, {
        'items': [
            {
                'item_type': arranger.PLACEHOLDER_TYPE,
                'cell': {'x': 0, 'y': -3},
                'span': {'x': 6, 'y': 5},
                'rearrange': False,
            }
        ]
    }],
    'dock_template': {
        'items': [
            {
                'item_type': arranger.PLACEHOLDER_TYPE,
                'cell': {'x': 0, 'y': 0},
                'span': {'x': 6, 'y': 1},
                'rearrange': False,
            }
        ]
    },
    'priority_groups': [
        {
            'apps': [
                "ru.mobstudio.andgalaxy",
                "ru.altarix.mos.pgu",
            ],
            'boost': True
        },
        {
            'apps': [
                "com.viber.wink",
                "com.vkontakte.android",
            ],
            'boost': False
        }
    ]
}

mask = np.zeros((len(config['screens_template']) + 1, user.grid_height, user.grid_width), dtype=np.bool)
mask[1, :2, 1:] = True
mask[1, -2, 0] = True

screens = [
    [{
        'item_type': arranger.PLACEHOLDER_TYPE,
        'cell': {'x': 0, 'y': 0},
        'span': {'x': 4, 'y': 1},
        'rearrange': False,
    }],
    [{
        'item_type': arranger.PLACEHOLDER_TYPE,
        'cell': {'x': 0, 'y': 3},
        'span': {'x': 4, 'y': 2},
        'rearrange': True,
    }, {
        'item_type': arranger.WIDGET_ITEM_TYPE,
        'value': 'com.yandex.launcher/.pogoda',
        'cell': {'x': 1, 'y': 0},
        'span': {'x': 3, 'y': 2},
        'rearrange': False,
    }, {
        'item_type': arranger.APP_ITEM_TYPE,
        'value': 'ru.mamba.client',
        'cell': {'x': 0, 'y': 3},
        'span': {'x': 1, 'y': 1},
        'rearrange': False,
    }],
    [{
        'item_type': arranger.PLACEHOLDER_TYPE,
        'cell': {'x': 0, 'y': 2},
        'span': {'x': 4, 'y': 3},
        'rearrange': False,
    }]
]
correct_arrangement = [[
  {'cell': {'x': 0, 'y': 0},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'ru.mobstudio.andgalaxy'},
  {'cell': {'x': 1, 'y': 0},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.instagram.android'},
  {'cell': {'x': 2, 'y': 0},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.facebook.katana'},
  {'cell': {'x': 3, 'y': 0},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.twitter.android'}],
 [{'cell': {'x': 0, 'y': 4},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.viber.wink'},
  {'cell': {'x': 1, 'y': 4},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'ru.ok.android'},
  {'cell': {'x': 2, 'y': 4},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.dev.puer.guestsvk'},
  {'cell': {'x': 3, 'y': 4},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'ru.altarix.gkh'},
  {'cell': {'x': 3, 'y': 3},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.google.android.apps.plus'},
  {'cell': {'x': 2, 'y': 3},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'co.vine.android'},
  {'cell': {'x': 1, 'y': 3},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'com.drive2'},
  {'cell': {'x': 1, 'y': 0},
   'item_type': arranger.WIDGET_ITEM_TYPE,
   'rearrange': False,
   'span': {'x': 3, 'y': 2},
   'value': 'com.yandex.launcher/.pogoda'},
  {'cell': {'x': 0, 'y': 3},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': False,
   'span': {'x': 1, 'y': 1},
   'value': 'ru.mamba.client'}],
 [{'cell': {'x': 0, 'y': 4},
   'item_type': arranger.APP_ITEM_TYPE,
   'rearrange': True,
   'span': {'x': 1, 'y': 1},
   'value': u'tv.periscope.android'}]]

apps = list(user.packages)
apps.remove('ru.mamba.client')
apps.remove('com.pinterest')
