from datetime import datetime

from jafar import mongo_configs
from jafar.utils import get_all_subclasses

FAKE_EXPIRE_AT = datetime(1996, 1, 31)
FAKE_LIFETIME = 100
FAKE_EXCEPTIONAL_LIFETIME = FAKE_LIFETIME - 1


def fake_config(config_class, name, **kwargs):
    return (
            config_class.objects.filter(name=name).first() or
            config_class(name=name, **kwargs).save(validate=False)
    )


def get_strategy_config(name):
    return fake_config(
        mongo_configs.StrategyConfig, name,
        card_configs=[
            mongo_configs.CardPreference(fake_config(cls, cls.__name__), 0.0)
            for cls in get_all_subclasses(mongo_configs.CardMongoConfig)
        ],
        constraints=[
            "BalancedRecommenderConstraint", "ContentTypeMappingConstraint",
            "RecommendationGroupAdjacencyConstraint"
        ]
    )


# noinspection PyTypeChecker
def fake_pipeline_recommender(name, pipeline):
    feed_recommender_config = fake_config(
        mongo_configs.TopNRecommenderConfig, name,
        pipeline=pipeline, title_pairs=[mongo_configs.TitlePair('title', 'subtitle')]
    )
    return fake_config(
        config_class=mongo_configs.FeedExperimentConfig,
        name=name,
        strategy=get_strategy_config(name),
        block_count=1,
        lifetime_seconds=FAKE_LIFETIME,
        page_limit=5,
        item_filter_size=1,
        explanation_filter_size=1,
        recommenders=[feed_recommender_config],
    )


def fake_gift_recommender(name, pipeline):
    feed_recommender_config = fake_config(mongo_configs.GiftsRecommenderConfig, name,
                                          pipeline=pipeline,
                                          title_pairs=[mongo_configs.TitlePair('title', 'subtitle')])
    fake_config(
        config_class=mongo_configs.FeedExperimentConfig,
        name=name,
        strategy=get_strategy_config(name),
        block_count=1,
        lifetime_seconds=FAKE_LIFETIME,
        page_limit=5,
        item_filter_size=1,
        explanation_filter_size=1,
        recommenders=[feed_recommender_config],
    )


def fake_vanga_config(name):
    fake_config(
        config_class=mongo_configs.VangaExperimentConfig,
        name=name,
        lifetime_seconds=FAKE_LIFETIME,
        exceptional_lifetime=FAKE_EXCEPTIONAL_LIFETIME,
        stats_groups=['personal_fallback']
    )
