import datetime
from uuid import UUID

from jafar import advisor_mongo
from jafar.tests.mocks.datasets import FIXTURE_REGIONS, FIXTURE_REGION_TYPES

MCC, MNC = 250, 99

user_id = '8c65ec13-99e4-43bc-9bd1-db98fc908b37'
bad_user_id = '%sQWERTY' % user_id
passport_uid = 111231313
apps = (
    "com.instagram.android",
    "com.facebook.katana",
    "com.twitter.android",
    "com.vkontakte.android",
    "ru.ok.android",
    "com.pinterest",
    "com.dev.puer.guestsvk",
    "ru.altarix.gkh",
    "com.google.android.apps.plus",
    "co.vine.android",
    "com.drive2",
    "ru.altarix.mos.pgu",
    "ru.mobstudio.andgalaxy",
    "tv.periscope.android",
    "com.viber.wink",
    "ru.mamba.client",
)
install_time = 1495207765


def fake_user_profile():
    advisor_mongo.db.profile.insert_one({
        '_id': UUID(user_id),
        'installed_apps_info': [{
            'package_name': package_name,
            'first_install_time': install_time,
            'is_system': False,
            'is_disabled': False
        } for package_name in apps],
        'created_at': datetime.datetime(2017, 1, 1),
        'updated_at': datetime.datetime(2018, 1, 1),
        'lbs_info': {
            'country': 'RU',
            'country_init': 'RU',
            'fix_country_init': False,
            'location': {'latitude': 54.997291, 'longitude': 73.377959},
            'mcc': MCC,
            'mnc': MNC,
            'operators': [{
                'mcc': MCC,
                'mnc': MNC
            }],
            'region_ids': FIXTURE_REGIONS,
            'region_types': FIXTURE_REGION_TYPES,
        },
        'android_info': {
            'os_build': {
                "string_fields": [
                    {
                        "value": "GT-I9500",
                        "key": "MODEL"
                    },
                ],
                'version': {
                    'codename': 'REL',
                    'incremental': '3728910',
                    'release': '5.1.1',
                    'sdk_int': 22
                },
            },
            'operators': [
                {
                    "carrier_name": "Vympelcom",
                    "display_name": "Beeline",
                    "country_iso": "RU",
                    "mcc": MCC,
                    "mnc": MNC,
                    "data_roaming": 0,
                    "sim_slot_index": 1,
                    "is_embedded": 0,
                    "icc_id": 13666
                }
            ]
        },
    })


def update_user_profile(user, add=None, remove=None, is_system=False, set_=None, unset=None):
    add = add or []
    remove = remove or []
    set_ = set_ or {}
    unset = unset or {}
    for item in add:
        advisor_mongo.db.profile.update_one(
            {'_id': UUID(user_id)},
            {
                '$push': {
                    'installed_apps_info': {
                        'package_name': item,
                        'first_install_time': 1495207765,
                        'is_system': is_system,
                        'is_disabled': False
                    }
                }
            }
        )

    for item in remove:
        advisor_mongo.db.profile.update_one(
            {'_id': UUID(user_id)},
            {
                '$pull': {
                    'installed_apps_info': {
                        'package_name': item
                    }
                }
            }
        )

    advisor_mongo.db.profile.update_one(
        {'_id': UUID(user_id)},
        {'$set': set_}
    )

    advisor_mongo.db.profile.update_one(
        {'_id': UUID(user_id)},
        {'$unset': unset}
    )
