import json
import os

from flask import current_app as app

from jafar.models.yandexphone import Gifts, GiftSet
from jafar.tests.fixtures.profile import passport_uid


def fake_gifts():
    gifts_filename = os.path.join(app.config['BASE_DIR'], 'fixtures', 'json', 'gifts.json')
    with open(gifts_filename) as gifts_file:
        for gift in Gifts.objects.from_json(gifts_file.read()):
            gift.save(force_insert=True)
    gift_set = [
        {
            'passport_uid': passport_uid,
            '_id': passport_uid,
            'created_at': {"$date": 1532361389533},
            'gifts': [
                {
                    'gift': 'money',
                    'activated': True,
                    'activated_at': {"$date": 1532361389533},
                },
                {
                    'gift': 'taxi',
                    'activated': False,
                    'promocode': 'taxi_promocode'
                },
                {
                    'gift': 'plus',
                    'activated': False,
                    'activated_at': {"$date": 1532361389533},
                }
            ]
        }
    ]

    for item in GiftSet.objects.from_json(json.dumps(gift_set)):
        item.save(force_insert=True)


def drop_gifts():
    Gifts.drop_collection()
    GiftSet.drop_collection()
