from unittest import TestCase

from jafar.arranger.strategy import FromLowerLeftOrder, HomescreensArrangement, FromLowerLeftSnakeOrder
from jafar.feed.recommenders import RecommendationGroup
from jafar.tests.fixtures.arranger import user, config, screens, mask, correct_arrangement, apps


class OrderTestCase(TestCase):
    def test_order_iterator(self):
        placeholder = {'cell': {'x': 10, 'y': 5}, 'span': {'x': 3, 'y': 2}}
        self.assertEqual(
            list(FromLowerLeftOrder(placeholder)),
            [(10, 6), (11, 6), (12, 6), (10, 5), (11, 5), (12, 5)]
        )


class OrderSnakeTestCase(TestCase):
    def test_order(self):
        placeholder = {'cell': {'x': 10, 'y': 5}, 'span': {'x': 3, 'y': 2}}
        self.assertEqual(
            list(FromLowerLeftSnakeOrder(placeholder)),
            [(10, 6), (11, 6), (12, 6), (12, 5), (11, 5), (10, 5)]
        )


class ArrangementTestCase(TestCase):
    def setUp(self):
        super(ArrangementTestCase, self).setUp()
        self.rec_group = RecommendationGroup(None, None, apps, None)
        self.arrangement = HomescreensArrangement(config=config, user=user)

    def test_prepare_grid(self):
        self.maxDiff = None
        self.assertListEqual(self.arrangement.mask.tolist(), mask.tolist())
        self.assertListEqual(self.arrangement.screens, screens)

    def test_fill_in(self):
        self.arrangement.fill_in(rec_groups=[self.rec_group])
        self.assertEqual(self.arrangement.screens, correct_arrangement)

    def test_apply_priority(self):
        prioritized = list(self.arrangement._apply_priority([self.rec_group]))
        for group in config['priority_groups']:
            self.assertEqual(sum(app in prioritized for app in group['apps']), 1)
            if group['boost']:
                self.assertEqual(group['apps'][0], prioritized[0])
