import numpy as np

from jafar.pipelines.blocks.blend import BlendingKFold
from jafar.tests.unittests.pipelines.blocks import BlockTestCase
from jafar.utils.structarrays import Series


class BlendingKFoldTestCase(BlockTestCase):
    def test_covering(self):
        array = self.get_installs()
        for n_folds in xrange(2, 10):
            res_test = Series(np.zeros(len(array), dtype=np.bool))
            for train, test in BlendingKFold(array=array, n_folds=n_folds):
                res_test ^= test
                self.assertTrue((train == ~test).all())
            self.assertTrue(np.all(res_test))

    def test_n_folds(self):
        array = self.get_installs()
        for n_folds in xrange(2, 10):
            self.assertEqual(n_folds, sum(1 for _ in BlendingKFold(array=array, n_folds=n_folds)))
