import mock
from mock import patch
import numpy as np
import unittest

from jafar.pipelines import ids
from jafar import advisor_replica_mongo
from jafar.tests.unittests.pipelines.blocks import BlockTestCase
from jafar.tests.mocks.datasets import mock_get_dataset_processor
from jafar.pipelines.blocks.data import OfflineReadDataBlock


class OfflineReadDataBlockTestCase(BlockTestCase):

    def test_read_train_data_block_installs(self):
        self._test_read_train_data_block(
            output_frame=ids.FRAME_KEY_ADVISOR_MONGO_INSTALLS, fields={'user', 'item', 'timestamp'}
        )

    @unittest.skip("No conversion fixtures at the moment")
    def test_read_train_data_block_conversions(self):
        self._test_read_train_data_block(
            output_frame=ids.FRAME_KEY_CONVERSIONS, fields={'user', 'item', 'timestamp'}
        )

    @patch('jafar.pipelines.blocks.data.get_dataset_processor', mock_get_dataset_processor)
    def _test_read_train_data_block(self, output_frame, fields):
        block = OfflineReadDataBlock(output_data=[output_frame])
        pipeline = mock.MagicMock()

        # train mode
        context = self.get_test_context(pipeline)
        result_context = block.apply(context, train=True)
        self.assert_same_context(context, result_context)
        self.assertIn(output_frame, result_context.data)
        self.assertEquals(len(result_context.data), 1)
        data = result_context.data[output_frame]
        self.assertEquals(data['user'].dtype, np.object)
        self.assertEquals(data['item'].dtype, np.object)
        self.assertEquals(data['value'].dtype, np.float32)
