import requests
import json


def print_request(request):
    req = "{method} {path_url} HTTP/1.0\r\n{headers}\r\n{body}".format(
        method=request.method,
        path_url=request.path_url,
        headers=''.join('{0}: {1}\r\n'.format(k, v) for k, v in request.headers.items()),
        body=request.body or "",
    )
    return "{req_size}\n{req}\r\n".format(req_size=len(req), req=req)


def post_json(host, namespace, headers, payload):
    req = requests.Request(
        'POST',
        'https://{host}{namespace}'.format(
            host=host,
            namespace=namespace,
        ),
        headers=headers,
        data=payload,
    )
    prepared = req.prepare()
    return print_request(prepared)


def make_request(experiment, host, text):
    payload = json.dumps(json.loads(text))
    return post_json(
        host,
        '/recommend/{}'.format(experiment),
        headers={
            'Host': host,
            'Content-Length': str(len(json.dumps(payload))),
            'Content-Type': 'application/json'
        },
        payload=payload
    )
