from jafar import jafar_mongo, advisor_mongo
from jafar.web.exceptions import ServiceUnavailable

import pymongo


def check_mongo_connections():
    try:
        for connection in (jafar_mongo, advisor_mongo):
            answer = connection.db.command('ping')
            if not answer.get('ok'):
                raise ServiceUnavailable({'error': str(answer)})
    except pymongo.errors.PyMongoError as e:
        raise ServiceUnavailable({'error': repr(e)})
    return True
