from itertools import islice


def consume(iterator, n):
    """ Advance the iterator n-steps ahead. If n is none, consume entirely. """
    next(islice(iterator, n, n), None)


def take(iterable, n):
    """ Return first n items of the iterable as a list """
    return list(islice(iterable, n))
