"""
Yandex.Launcher-specific operations.
"""
import logging
from collections import defaultdict

from jafar import app_info_loader

logger = logging.getLogger(__name__)


def category_feature_extractor(document, feature):
    assert feature == 'category', 'Category feature extractor can only be used for `category` feature'
    categories = document.get('categories', [])
    # NOTE: apps can have multiple categories, but we just take the first
    # one for now
    if len(categories) > 0:
        return categories[0], True
    else:
        return None, False


def get_categories_for_apps(package_names):
    """
    :returns: dictionary of {package_name: category} containing all
    requested package names, if corresponding category is found in the
    database.
    """
    result = defaultdict(lambda: None)
    app_info_map = app_info_loader.load(package_names, raise_on_missing=False)
    for package_name, app_info in app_info_map.iteritems():
        value, valid = category_feature_extractor(app_info, 'category')
        if valid:
            result[package_name] = value
    return result
