import logging
from cStringIO import StringIO
from contextlib import contextmanager


@contextmanager
def redirect_logging(logger_name):
    try:
        output = StringIO()
        logger = logging.getLogger(logger_name)
        old_stream = logger.handlers[0].stream
        logger.handlers[0].stream = output
        yield output
    finally:
        logger.handlers[0].stream = old_stream
