from blackbox import JsonBlackbox
from flask import current_app as app


HAS_PLUS_ATTRIBUTE_ID = '1015'
PASSPORT_LOGIN_ALIAS_ID = '1'


def get_blackbox_api_client():
    return JsonBlackbox(
        tvm2_client_id=app.config['TVM_CLIENT_ID'],
        tvm2_secret=app.config['TVM_CLIENT_SECRET'],
        blackbox_client=app.config['BLACKBOX_CLIENT'],
    )


def user_info_by_login(login):
    return _user_info(login=login)


def user_info_by_uid(uid):
    return _user_info(uid=uid)


def _user_info(**kwargs):
    blackbox_api = get_blackbox_api_client()

    params = {
        'userip': '127.0.0.1',  # Necessary parameter, so passing localhost to ignore it
        'aliases': PASSPORT_LOGIN_ALIAS_ID,
        'attributes': HAS_PLUS_ATTRIBUTE_ID,
    }
    params.update(kwargs)

    response = blackbox_api.userinfo(**params)
    user = response['users'][0]
    if not user['id']:
        return {}

    return {
        'uid': user['id'],
        'login': user['login'],
        'has_plus': user['attributes'].get(HAS_PLUS_ATTRIBUTE_ID) == '1',
        'is_portal_login': PASSPORT_LOGIN_ALIAS_ID in user['aliases'],
    }
