# -*- coding: utf-8 -*-
import urllib

from urlparse import urlparse, parse_qsl, urlunparse
from collections import OrderedDict
from codecs import BOM_UTF8

BOM_LENGTH = len(BOM_UTF8)


def rewrite_url(url, host, scheme='https', path_prefix=''):
    parsed = urlparse(url)
    replaced = parsed._replace(scheme=scheme, netloc=host, path=path_prefix + parsed.path)
    return replaced.geturl()


def add_params_to_url(url, params):
    """
    Function updates url adding new parameters passed in params.
    If a parameter already exists, it will be rewritten. If there are duplicating parameters, only
    the last one will be included in resulting string. Function keeps the order of parameters.
    :param url: string
    :param params: dict
    :return: string
    """
    parsed_url = urlparse(url)
    query = OrderedDict(parse_qsl(parsed_url.query))
    query.update(params)
    # noinspection PyProtectedMember
    return urlunparse(parsed_url._replace(query=urllib.urlencode(query, True)))


def remove_params_from_url(url, params):
    """
    Function updates url removing parameters passed in params.
    If there are duplicating parameters, all of them will be removed.
    Function keeps the order of parameters.
    :param url: string
    :param params: iterable containing strings with parameters' names
    :return: string
    """
    parsed_url = urlparse(url)
    query = OrderedDict(parse_qsl(parsed_url.query))
    for param in params:
        query.pop(param, None)
    # noinspection PyProtectedMember
    return urlunparse(parsed_url._replace(query=urllib.urlencode(query, True)))
