from collections import defaultdict
from itertools import chain

from flask import current_app as app

from jafar import clickhouse, vanga_general_stats_loader

vanga_query_personal_class_name = """
    SELECT item, class_name, groupArray(array({context}, count)) FROM (
        SELECT
            item,
            class_name,
            toUInt64({context}) as {context},
            sum(app_launch_count) as count
        FROM {db}.{table_name}
        WHERE user = %(user)s
        {filter_clause}
        GROUP BY item, class_name, {context}
    ) GROUP BY item, class_name
"""
vanga_query_personal_package_name = """
    SELECT item, NULL, groupArray(array({context}, count)) FROM (
        SELECT
            item,
            toUInt64({context}) as {context},
            sum(app_launch_count) as count
        FROM {db}.{table_name}
        WHERE user = %(user)s
        {filter_clause}
        GROUP BY item, {context}
    ) GROUP BY item
"""


def get_any_launch(device_id):
    return clickhouse.execute("""
            SELECT
                1
            FROM {db}.{usage_logs}
            WHERE user = %(user)s AND event_name = 'app_launch'
            LIMIT 1
        """.format(
        db=app.config['CLICKHOUSE_DATABASE'],
        usage_logs=app.config['CLICKHOUSE_USAGE_LOGS_TABLE']
    ), {'user': device_id})


def get_apps_total_stats(apps, packages_to_classnames, by_class_names):
    loaded = vanga_general_stats_loader.load(apps)

    if not by_class_names:
        # merge stats of one package divided by activities
        packages_to_classnames = defaultdict(set)
        for package_name in loaded:
            loaded[package_name] = [max(loaded[package_name], key=lambda x: x['personal'])]
            loaded[package_name][0].pop('class_name', None)

    stats = {}
    for stats_item in chain.from_iterable(loaded.itervalues()):
        package_name, class_name = stats_item['package_name'], stats_item.get('class_name')
        if package_name not in packages_to_classnames or class_name in packages_to_classnames[package_name]:
            stats[(stats_item['package_name'], stats_item.get('class_name'))] = stats_item

    return stats
