import re

from flask import current_app as app

from jafar.utils.tvm import add_service_ticket_header


def prepare_url_and_headers(url, headers=None, timeout=None):
    """Prepares request headers and URL for Zora"""
    if headers is None:
        headers = {}

    headers = add_service_ticket_header(app.config['ZORA_CLIENT_ID'], headers)

    headers.update({
        'X-Yandex-Langregion': 'RU',
        'X-Yandex-Sourcename': 'jafar'
    })

    if timeout is not None:
        headers.update({'X-Yandex-Response-Timeout': str(timeout)})

    if url.startswith('https'):  # if we need HTTPS we should add header and s/https/http
        headers.update({'X-Yandex-Use-Https': 'true'})
        url = re.sub('^https', 'http', url)

    return url, headers
