"""
Maintenance views
"""

from flask import redirect, Blueprint, current_app as app

from jafar.utils import io
from jafar.utils.health_checks import check_mongo_connections
from jafar.web import JsonResponse
from jafar.web.exceptions import ServiceUnavailable

common_blueprint = Blueprint('common', __name__)


@common_blueprint.route('/ping')
def ping():
    check_mongo_connections()
    if app.config['DEPLOYMENT_TYPE'] == app.config['QLOUD'] and not io.qloud_snapshot_is_ready():
        raise ServiceUnavailable({'error': 'Qloud container is not using its pre-packaged snapshot'})
    return JsonResponse({'result': 'ok'})


@common_blueprint.route('/')
def index():
    return redirect('/admin/')
