from version import VERSION
from flask import Response
import ujson


class JsonResponse(Response):
    default_status = 200
    default_mimetype = "application/json"

    def __init__(self, content, headers=None, *args, **kwargs):
        super(JsonResponse, self).__init__(
            response=ujson.dumps(
                content,
                escape_forward_slashes=False,
            ),
            *args, **kwargs
        )
        self.headers["X-Jafar-Version"] = VERSION
        self.headers.extend(headers or {})
