from werkzeug.exceptions import HTTPException
from jafar.web import JsonResponse


class JsonException(HTTPException):
    details = None
    headers = None

    def __init__(self, details=None):
        super(JsonException, self).__init__()
        if details:
            self.details = details

    def get_response(self, environ=None):
        return JsonResponse(content=self.details, status=self.code, headers=self.headers)


class BadRequest(JsonException):
    code = 400


class NotFound(JsonException):
    code = 404


class ServiceUnavailable(JsonException):
    code = 503
    headers = {
        'Retry-After': 60 * 3
    }
