import warnings
from werkzeug.middleware.proxy_fix import ProxyFix

from jafar import create_app

# no warnings in production logs
warnings.filterwarnings('ignore')

# assuming production server: eager mode is enabled
app = create_app(MEMMAP_STORAGE_MODE='eager')
app.wsgi_app = ProxyFix(app.wsgi_app)

# monkey-patch thread-local variable for correct work under gevent
# https://st.yandex-team.ru/ADVISOR-1866
from gevent.local import local
import ylog

ylog.context.ContextFormatter.thread_data = local()
