import json
from nile.api.v1 import Record


def mapper(records):
    for record in records:
        event_name = record.get('EventName')
        if event_name in ('app_launch', 'App_install'):
            try:
                event_value = json.loads(record['EventValue'])
            except (ValueError, KeyError):
                continue

            package_name = event_value.get('package_name') or event_value.get('packageName')
            if not package_name:
                continue

            yield Record(
                event=event_name,
                item=package_name
            )


class CountReducer(object):
    def __init__(self, date):
        self.date = date

    def __call__(self, groups):
        for result, records in groups:
            launches = 0
            installs = 0
            for record in records:
                event = record['event']
                if event == 'app_launch':
                    launches += 1
                elif event == 'App_install':
                    installs += 1
            yield result.update(
                date=self.date,
                launches=launches,
                installs=installs
            )


class TrendReducer(object):
    def __init__(self, tables_count, count_stat):
        self.tables_count = tables_count
        self.count_stat = count_stat

    def __call__(self, groups):
        for result, records in groups:

            # ignore zero count stats
            records = [record for record in records if record[self.count_stat] > 0]
            if len(records) < self.tables_count:
                continue

            # it's important for trend analysis to sort by date
            records = sorted(records, key=lambda x: x['date'])
            yield result.update(
                counts=map(lambda x: x[self.count_stat], records)
            )
