# -*- coding: utf-8 -*-
# source: https://github.yandex-team.ru/rasp/urban/blob/9681a7fe8ddad4667e28707d86fc0d2480885479/www/utils/data.py

translit_tables = {
    'cyr-lat': {u'а': u'a', u'б': u'b', u'в': u'v', u'г': u'g', u'д': u'd', u'е': u'e',
                u'ж': u'zh', u'з': u'z', u'и': u'i', u'й': u'j', u'к': u'k', u'л': u'l',
                u'м': u'm', u'н': u'n', u'о': u'o', u'п': u'p', u'р': u'r', u'с': u's',
                u'т': u't', u'у': u'u', u'ф': u'f', u'х': u'kh', u'ц': u'ts', u'ч': u'ch',
                u'ш': u'sh', u'щ': u'shch', u'ъ': u'', u'ы': u'y', u'ь': u'', u'э': u'e',
                u'ю': u'yu', u'я': u'ya', u'ё': u'yo'},

    # таблица сделана в основном расчете на транслитерированный поиск, возможно требуется
    # коррекция для более широкого применения
    'lat-cyr': {u'a': u'а', u'b': u'б', u'c': u'ц', u'd': u'д', u'e': u'е', u'f': u'ф',
                u'g': u'г', u'h': u'х', u'i': u'и', u'j': u'й', u'k': u'к', u'l': u'л',
                u'm': u'м', u'n': u'н', u'o': u'о', u'p': u'п', u'q': u'я', u'r': u'р',
                u's': u'с', u't': u'т', u'u': u'у', u'v': u'в', u'w': u'в', u'x': u'х',
                u'y': u'ы', u'z': u'з'},
}

for table in translit_tables.values():
    cap_table = {}
    for orig, new in table.iteritems():
        cap_table[orig.capitalize()] = new.capitalize()
    table.update(cap_table)


def transliterate(text, table_name):
    """
    Транслитерация по таблицам
    >>> transliterate(u'абвгдеёжзийклмнопрстуфхчцшщъыьэюя', 'cyr-lat')
    u'abvgdeyozhzijklmnoprstufkhchtsshshchyeyuya'

    >>> transliterate(u'abcdefghijklmnopqrstuvwxyz', 'lat-cyr')
    u'абцдефгхийклмнопярстуввхыз'
    """

    if text:
        table = translit_tables.get(table_name)
        if table:
            text = u''.join(table.get(char, char) for char in text)

    return text
