import os
import shutil
import subprocess
try: # for pip >= 10
    from pip._internal.commands.wheel import WheelCommand
except ImportError:
    from pip.commands.wheel import WheelCommand

# TODO(anglerfish) move it to settings.py and make
# config dependency-free (ADVISOR-1343)
NILE_WHEELS_DIR = 'jafar_yt/nile_wheels'
NILE_WHEELS = [
    'pillow==5.2.0',
    'colorwiz',
    'pymongo==3.5.1',
    'numpy==1.16.4',
    'beautifulsoup4==4.6.3',
    'yandex-http-geobase==0.1.1',
    'PyStemmer==1.3.0',
    'langdetect==1.0.7',
]


def ensure_dir():
    if os.path.exists(NILE_WHEELS_DIR):
        shutil.rmtree(NILE_WHEELS_DIR)
    os.makedirs(NILE_WHEELS_DIR)


if __name__ == '__main__':
    if NILE_WHEELS:
        ensure_dir()
        command = WheelCommand()
        options, args = command.parser.parse_args()
        options.index_url = 'https://pypi.yandex-team.ru/simple/'
        options.wheel_dir = NILE_WHEELS_DIR
        command.run(options, NILE_WHEELS)

    subprocess.call(['python', 'jafar_yt/setup.py', 'bdist_wheel', '--dist-dir={}'.format(NILE_WHEELS_DIR)])
