#!/usr/bin/env python
import sys

from flask_script import Manager, Server
from ylog.context import log_context

from jafar import create_app

manager = Manager(create_app)


# submanagers
def sub_opts(app, **kwargs):
    pass


# train
from jafar.commands.train.update_datasets import UpdateDatasets
from jafar.commands.train.update_apps_info import UpdateAppsInfoYT, UpdateAppsInfoMongo, MountAppsInfoDynamicTable
from jafar.commands.train.train_recommenders import TrainRecommenders
from jafar.commands.train.update_vanga_stats import UpdateVangaStats
from jafar.commands.train.upload_snapshot import UploadSnapshot


class TrainManager(Manager):
    """
    Everything related to recommender training and snapshot updates
    """


train_manager = TrainManager(sub_opts)
train_manager.add_command('update_datasets', UpdateDatasets())
train_manager.add_command('update_apps_info_yt', UpdateAppsInfoYT())
train_manager.add_command('update_apps_info_mongo', UpdateAppsInfoMongo())
train_manager.add_command('mount_apps_info_dynamic_table', MountAppsInfoDynamicTable())
train_manager.add_command('train_recommenders', TrainRecommenders())
train_manager.add_command('upload_snapshot', UploadSnapshot())
train_manager.add_command('update_vanga_stats', UpdateVangaStats())

# stats
from jafar.commands.stats.update_usage_stats import UpdateUsageStats
from jafar.commands.stats.update_users import UpdateUsersYt, UpdatePhonesYt, UpdatePhonesClickHouse
from jafar.commands.stats.update_trend_data import TrendDataUpdaterCommand
from jafar.commands.stats.update_phone_stats import UpdatePhoneStats
from jafar.commands.stats.proper_metrics import ProperMetricsStatsBase


class StatsManager(Manager):
    """
    Stat collection and regular YT/Mongodb updates
    """


stats_manager = StatsManager(sub_opts)
stats_manager.add_command('update_usage_stats', UpdateUsageStats())
stats_manager.add_command('update_users_yt', UpdateUsersYt())
stats_manager.add_command('update_phones_yt', UpdatePhonesYt())
stats_manager.add_command('update_phones_clickhouse', UpdatePhonesClickHouse())
stats_manager.add_command('update_trend_data', TrendDataUpdaterCommand())
stats_manager.add_command('update_phone_stats', UpdatePhoneStats())
stats_manager.add_command('calculate_ndcg', ProperMetricsStatsBase())

# other stuff
from jafar.commands.update_snapshot import UpdateSnapshot
from jafar.commands.migrate_user import MigrateUser
from jafar.commands.ensure_indexes import EnsureIndexes
from jafar.commands.clean_yt import CleanYT

manager.add_command('update_snapshot', UpdateSnapshot())
manager.add_command('runserver', Server(host="::", port=5001))
manager.add_command('migrate_user', MigrateUser())
manager.add_command('ensure_indexes', EnsureIndexes())
manager.add_command('cleanup_yt', CleanYT())

# top-level manager options
manager.add_option('--profile', dest='profile', default=False, required=False, action='store_true')
manager.add_option('--profile-dir', dest='profile_dir', required=False, type=str)
manager.add_option('--disable-logging', dest='disable_logging', default=False, required=False, action='store_true')
manager.add_option('--storage-mode', dest='storage_mode', default='lazy', required=False, type=str,
                   choices=('lazy', 'eager'))
manager.add_option('--replica-data', dest='replica_data', default=False, required=False, action='store_true')

manager.add_command('train', train_manager)
manager.add_command('stats', stats_manager)

if __name__ == "__main__":
    # make script name from first 1 or 2 arguments
    script_name = '_'.join(sys.argv[1:3])
    with log_context(script_name=script_name):
        manager.run()
