#!/usr/bin/env python
from argparse import ArgumentParser
from datetime import datetime, timedelta

from pymongo import MongoClient

from settings import MONGO_DBNAME, MONGO_URI

UPDATED_AGE_WARN_LEVEL = timedelta(hours=2)
UPDATED_AGE_CRITICAL_LEVEL = timedelta(hours=6)

ACTION_CHOICES = ('check_promo_updating',)

db = MongoClient(MONGO_URI)[MONGO_DBNAME]
parser = ArgumentParser(description='Jafar monitor')
parser.add_argument('--action', dest='action', help='monitoring action', choices=ACTION_CHOICES, required=True)


def find_outdated_adnetworks(time_delta):
    return db.promo_offer.distinct(key="adnetwork_name", filter={'updated': {"$lt": datetime.utcnow() - time_delta}})


def check_promo_updating():
    outdated_adnetworks = find_outdated_adnetworks(UPDATED_AGE_WARN_LEVEL)
    if outdated_adnetworks:
        return "1;outdated offers (>2 hours), adnetworks %s" % ','.join(outdated_adnetworks)
    outdated_adnetworks = find_outdated_adnetworks(UPDATED_AGE_CRITICAL_LEVEL)
    if outdated_adnetworks:
        return "2;outdated offers (>6 hours), adnetworks %s" % ', '.join(outdated_adnetworks)
    return "0;ok"


if __name__ == '__main__':
    options = parser.parse_args()

    if options.action == 'check_promo_updating':
        print check_promo_updating()
